#version 150 compatibility

#include "/includes/main.glsl"
#define OVERWORLD

in vec2 lmtexcoord;
in float isflower;

#if SHADOW_FILTERING == 2
flat in vec4 color;
#endif

#if defined DISTANT_HORIZONS
in vec3 viewVector;
#endif

out vec4 fragColor;

void main()
{
    /* DRAWBUFFERS:0 */

#if defined DISTANT_HORIZONS
    float noise = R2_dither_slow(gl_FragCoord.xy);
    float farval = min(shadowDistance, far);

    float dist = length(viewVector);

    float fadeDist = 32.0;

    float blend = smoothstep(farval - fadeDist, farval, dist);

    if (blend > noise && isflower > 0)
    {
        discard;
    }
#endif

#if SHADOW_FILTERING > 1
    vec4 outcolor = texture(tex, lmtexcoord.xy);
    outcolor.rgb *= color.rgb;
    outcolor.rgb = toLinear(outcolor.rgb);
    fragColor = vec4(outcolor);
    if (fragColor.a == 0)
    {
        discard;
    }
#else
    fragColor = vec4(0, 0, 0, texture(tex, lmtexcoord.xy).a);

    if (fragColor.a == 0)
    {
        discard;
    }
#endif
}
